/* Test de robustesse patrimoine */
***********************************

set more off
clear 

* A) On garde l'imputation des revenus avie et liquidits mais on applique un seul rdt financier  l'ensemble des revenus financiers
* B) Imputation avie proportionnel aux intrts, dividendes et liquidits
* C) Imputation avie proportionnel aux intrts, dividendes 
* Note : Dans les trois scnarios, on garde l'imputation des revenus de liquidits

foreach pas of global yearliste {
global year=`pas'



********************************
* I) Importation of parameters *
********************************		
	* Patrimoine NA par type d'actifs + revenus du capital NA par type d'actifs (after indirect taxes)
			import excel using "$param/GGP2016DINAAppendixA.xlsx",first clear sheet("statacapital") cellrange(A7:R71) 
			* Transformation de tous les parametres en macrovariables */
					foreach var of varlist _all {
						quiet sum `var' if year==${year}
						global `var'=r(mean)
					}
	

**************************
* II)  Robustness check  *
**************************	
	
	* A) Un seul rdt financier
			use "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			drop patfin_cn patfin_div_cn patfin_int_cn patfin_liqu_cn patfin_av_cn patfon_owner_net_cn patfon_rent_net_cn patfon_brut_cn- passif_rent_cn 
			gen temp=rfin_div_cn+ rfin_int_cn +rfin_liqu_cn+ rfin_av_cn
			quiet sum temp [aw=pondn]
			gen patfin_cn=(rfin_div_cn+ rfin_int_cn +rfin_liqu_cn+ rfin_av_cn)*(${patfin_intNA}+${patfin_divNA}+${patfin_avNA}+${patfin_liquNA}	)*1000000000/r(sum)
			replace pat_cn=patfon_net_cn+patfin_cn+patpro_cn
			drop rcap_cn- rfin_av_cn temp ntot ndecl pac age
			foreach var of newlist pat patfon_net patpro patfin {
				rename `var'_cn `var'_A
			}
			save "$wfrobust/Life insurance/robustnesswealthcn${year}.dta",replace

	* B) Imputation avie proportionnel aux intrts, dividendes et liquidits
			use "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			
			* Imputation rev avie
				gen temp=0
				replace temp=rfin_div_cn+ rfin_int_cn+rfin_liqu_cn if pac==0
				quiet sum temp [aw=pondn]
				replace rfin_av_cn= (rfin_div_cn+ rfin_int_cn+rfin_liqu_cn)*${revavieNA}*1000000000/r(sum)
				drop temp
			* Patrimoine 
				gen temp=0
				replace temp=rfin_div_cn+ rfin_int_cn +rfin_liqu_cn if pac==0
				quiet sum temp [aw=pondn]
				replace patfin_av_cn=(rfin_div_cn+ rfin_int_cn +rfin_liqu_cn)* ${patfin_avNA}*1000000000/r(sum) if pac==0
				replace patfin_cn=patfin_div_cn+ patfin_int_cn+ patfin_liqu_cn +patfin_av_cn
				replace pat_cn=patfon_net_cn+patfin_cn+patpro_cn
				drop  patfin_div_cn patfin_int_cn patfin_liqu_cn patfin_av_cn  patfon_owner_net_cn patfon_rent_net_cn patfon_brut_cn- passif_rent_cn
				drop rcap_cn- rfin_av_cn temp ntot ndecl pac age
				foreach var of newlist pat patfon_net patpro patfin {
					rename `var'_cn `var'_B
				}
				merge 1:1 year idindiv using "$wfrobust/Life insurance/robustnesswealthcn${year}.dta"
				drop _merge
				save "$wfrobust/Life insurance/robustnesswealthcn${year}.dta",replace
				
	* C) Imputation avie proportionnel aux intrts, dividendes 
			use "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			
			* Imputation rev avie
				gen temp=rfin_div_cn+ rfin_int_cn
				quiet sum temp [aw=pondn]
				replace rfin_av_cn= (rfin_div_cn+ rfin_int_cn)*${revavieNA}*1000000000/r(sum)
				drop temp
			* Patrimoine 
				gen temp=rfin_div_cn+ rfin_int_cn
				quiet sum temp [aw=pondn]
				replace patfin_av_cn=(rfin_div_cn+ rfin_int_cn)* ${patfin_avNA}*1000000000/r(sum)
				replace patfin_cn=patfin_div_cn+ patfin_int_cn+ patfin_liqu_cn +patfin_av_cn
				replace pat_cn=patfon_net_cn+patfin_cn+patpro_cn
				drop  patfin_div_cn patfin_int_cn patfin_liqu_cn patfin_av_cn  patfon_owner_net_cn patfon_rent_net_cn patfon_brut_cn- passif_rent_cn
				drop rcap_cn- rfin_av_cn temp ntot ndecl pac age
				foreach var of newlist pat patfon_net patpro patfin {
					rename `var'_cn `var'_C
				}
				merge 1:1 year idindiv using "$wfrobust/Life insurance/robustnesswealthcn${year}.dta"
				drop _merge
				save "$wfrobust/Life insurance/robustnesswealthcn${year}.dta",replace
				
macro drop  revfon_fictifNA revavieNA revfonNA revdivNA revliquNA revintNA patproNA patfin_intNA patfin_divNA patfin_avNA patfon_rentNA patfon_ownerNA patfin_liquNA  
}
	


